/**
 * ./src/classes/ovary.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IWorkDir } from '../interfaces/index.js';
import CliAutologin from './cli-autologin.js';
import Incubator from './incubation/incubator.js';
import { bindLiveFs, uBindLiveFs } from './ovary.d/bind-live-fs.js';
import { bindVfs, ubindVfs } from './ovary.d/bind-vfs.js';
import { createXdgAutostart } from './ovary.d/create-xdg-autostart.js';
import { editLiveFs } from './ovary.d/edit-live-fs.js';
import { fertilization } from './ovary.d/fertilization.js';
import { finished } from './ovary.d/finished.js';
import { initrdAlpine, initrdArch, initrdDebian, initrdDracut } from './ovary.d/initrd.js';
import { kernelCopy } from './ovary.d/kernel-copy.js';
import { liveCreateStructure } from './ovary.d/live-create-structure.js';
import { luksGetPassword } from './ovary.d/luks-get-password.js';
import { buildLuksFormatArgs, luksExecuteCommand } from './ovary.d/luks-helpers.js';
import { installHomecryptSupport } from './ovary.d/luks-home-support.js';
import { luksHome } from './ovary.d/luks-home.js';
import { CryptoConfig, interactiveCryptoConfig } from './ovary.d/luks-interactive-crypto-config.js';
import { luksRootInitrd } from './ovary.d/luks-root-initrd.js';
import { luksRoot } from './ovary.d/luks-root.js';
import { luksShrink } from './ovary.d/luks-shrink.js';
import { makeDotDisk } from './ovary.d/make-dot-disk.js';
import { makeEfi } from './ovary.d/make-efi.js';
import { makeIso } from './ovary.d/make-iso.js';
import { addExclusion, makeSquashfs } from './ovary.d/make-squashfs.js';
import { copied, merged, mergedAndOverlay } from './ovary.d/merged.js';
import { produce } from './ovary.d/produce.js';
import { syslinux } from './ovary.d/syslinux.js';
import userCreateLive from './ovary.d/user-create-live.js';
import usersRemove from './ovary.d/users-remove.js';
import { xorrisoCommand } from './ovary.d/xorriso-command.js';
import Settings from './settings.js';
/**
 * Ovary:
 */
export default class Ovary {
    addExclusion: typeof addExclusion;
    bindLiveFs: typeof bindLiveFs;
    bindVfs: typeof bindVfs;
    buildLuksFormatArgs: typeof buildLuksFormatArgs;
    cliAutologin: CliAutologin;
    clone: boolean;
    compression: string;
    copied: typeof copied;
    createXdgAutostart: typeof createXdgAutostart;
    distroId: string;
    distroLike: string;
    distroLiveMediumPath: string;
    dotLivefs: string;
    dotMnt: string;
    dotOverlay: IWorkDir;
    echo: {};
    editLiveFs: typeof editLiveFs;
    familyId: string;
    fertilization: typeof fertilization;
    finished: typeof finished;
    fullcrypt: boolean;
    genisoimage: boolean;
    hidden: boolean;
    homecrypt: boolean;
    incubator: Incubator;
    initrd: string;
    initrdAlpine: typeof initrdAlpine;
    initrdArch: typeof initrdArch;
    initrdDebian: typeof initrdDebian;
    initrdDracut: typeof initrdDracut;
    installHomecryptSupport: typeof installHomecryptSupport;
    interactiveCryptoConfig: typeof interactiveCryptoConfig;
    kernel: string;
    kernelCopy: typeof kernelCopy;
    liveCreateStructure: typeof liveCreateStructure;
    luksConfig: CryptoConfig;
    luksDevice: string;
    luksExecuteCommand: typeof luksExecuteCommand;
    luksFile: string;
    luksGetPassword: typeof luksGetPassword;
    luksHome: typeof luksHome;
    luksMappedName: string;
    luksMountpoint: string;
    luksPassword: string;
    luksRoot: typeof luksRoot;
    luksRootInitrd: typeof luksRootInitrd;
    luksShrink: typeof luksShrink;
    makeDotDisk: typeof makeDotDisk;
    makeEfi: typeof makeEfi;
    makeIso: typeof makeIso;
    makeSquashfs: typeof makeSquashfs;
    merged: typeof merged;
    mergedAndOverlay: typeof mergedAndOverlay;
    nest: string;
    produce: typeof produce;
    settings: Settings;
    snapshot_basename: string;
    snapshot_prefix: string;
    syslinux: typeof syslinux;
    theme: string;
    toNull: string;
    uBindLiveFs: typeof uBindLiveFs;
    ubindVfs: typeof ubindVfs;
    userCreateLive: typeof userCreateLive;
    usersRemove: typeof usersRemove;
    uuid: string;
    verbose: boolean;
    vmlinuz: string;
    volid: string;
    xorrisoCommand: typeof xorrisoCommand;
}
