/**
 * ./src/appimage/dependency-manager.ts
 * penguins-eggs v.25.11.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export declare class DependencyManager {
    familyId: string;
    private appRoot;
    private distro;
    constructor();
    /**
     * Installa i distro meta-pacchetti corretti in base alla distribuzione.
     */
    installDistroPackages(): boolean;
    /**
     * Verifica se i distro-meta-pacchetto sono già installati nel sistema.
     * @returns true se installati, false altrimenti
     */
    isInstalled(): boolean;
    /**
     * Reinstalla i distro-meta-pacchetti: Rimuove e poi Installa.
     * Utile per forzare un aggiornamento delle dipendenze o riparare un'installazione.
     */
    reinstallDistroPackages(): boolean;
    /**
     * Rimuove i distro meta-pacchetti e pulisce le dipendenze.
     */
    removeDistroPackages(): boolean;
}
