import { IDistro, IInstaller } from '../../interfaces/index.js';
export default class Fisherman {
    distro: IDistro;
    installer: IInstaller;
    verbose: boolean;
    constructor(distro: IDistro, installer: IInstaller, verbose?: boolean);
    /**
     *
     * @param name
     * @param isScript
     */
    buildCalamaresModule(name: string, isScript?: boolean, theme?: string): Promise<string>;
    /**
     *
     * @param name
     */
    buildCalamaresPy(name: string): Promise<void>;
    /**
     *
     * @param name
     * @param replaces [['search','replace']]
     */
    buildModule(name: string, vendor?: string): Promise<void>;
    /**
     * buildModuleDracut
     */
    buildModuleDracut(initrd: string): Promise<void>;
    /**
     * buildModuleFinished
     */
    buildModuleFinished(): Promise<void>;
    buildModuleInitcpio(): Promise<void>;
    /**
     * buildModulePackages
     */
    buildModulePackages(distro: IDistro, release?: boolean): Promise<void>;
    /**
     * buildModuleRemoveuser
     */
    buildModuleRemoveuser(username: string): Promise<void>;
    /**
     * ====================================================================================
     * buildModule...
     * ====================================================================================
     */
    /**
     * buildModuleUnpackfs
     */
    buildModuleUnpackfs(): Promise<void>;
    /**
     *
     * @param name
     */
    contextualprocess(name: string): Promise<void>;
    /**
     * write settings
     */
    createCalamaresSettings(theme?: string, isClone?: boolean): Promise<void>;
    /**
     *
     * @param name
     */
    helper(name: string): Promise<void>;
    /**
     *
     * @param name
     */
    shellprocess(name: string): Promise<void>;
    /**
     *
     * @param module
     * @param type
     * @param path
     */
    show(name: string, type: string, path: string): void;
}
