/**
 * ./src/classes/utils.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 *
 * Refactored Utils class - imports from modular utilities
 */
import IOsRelease from '../interfaces/i-os-release.js';
/**
 * Utils: general porpourse utils
 * @remarks all the utilities
 */
export default class Utils {
    static vmlinuz(kernel?: string): string;
    /**
     * @deprecated Use Kernel.initramfs() instead
     */
    static initrdImg(kernel?: string): string;
    /**
    * Custom function to sort object keys
    * @param obj
    * @returns
    */
    static sortObjectKeys(obj: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
    /**
     *
     * @param file
     * @param search
     * @returns value
     */
    static searchOnFile(file?: string, search?: string): string;
    /**
     * Restituisce il prefisso della iso
     * @param distroId
     * @param codenameId
     */
    static snapshotPrefix(distroId: string, codenameId: string): string;
    /**
     * isAppImage
     */
    static isAppImage(): boolean;
    /**
     * Detect if running inside a container (Docker or LXC)
     */
    static isContainer(): boolean;
    /**
     * Check if the system uses Systemd
     */
    static isSystemd(): boolean;
    /**
     * Check if the system uses SysVinit
     */
    static isSysvinit(): boolean;
    /**
     * Check if the system uses OpenRC
     */
    static isOpenRc(): boolean;
    /**
     * Usata da pacman e config credo non serva affatto
     */
    static machineId(): string;
    /**
     *
     * @param msg
     */
    static warning(msg?: string): void;
    static info(msg?: string): void;
    static success(msg?: string): void;
    static error(msg?: string): void;
    /**
     * Return the primary user's name
     */
    static getPrimaryUser(): Promise<string>;
    /**
     * restituisce uuid
     * @param device
     */
    static uuid(device: string): string;
    /**
     *
     * @param device
     * @returns
     */
    static uuidGen(): string;
    /**
     *
     * @param date
     */
    static formatDate(date: Date): string;
    /**
     * return the name of the package: penguins-eggs
     * @returns penguins-eggs
     */
    static getPackageName(): string;
    /**
     * Count the eggs present in the nest
     * @returns {number} Numero degli snapshot presenti
     */
    static getSnapshotCount(snapshot_dir?: string): number;
    /**
     * Get the syze of the snapshot
     * @returns {string} grandezza dello snapshot in Byte
     */
    static getSnapshotSize(snapshot_dir?: string): number;
    /**
     * uefiArch
     * @returns arch
     */
    static uefiArch(): string;
    /**
     * i386-pc,
     * i386-efi,
     * x86_64-efi,
     * arm64-efi,
     *
     * ATTEMZIONE: install efibootmgr
     *
     * Fedora/RHEL have i386-pc
     */
    static uefiFormat(): string;
    /**
     *
     * @returns
     */
    static usrLibPath(): string;
    /**
     *
     * @param prefix
     * @param backup
     * @returns
     */
    static getPrefix(prefix: string, backup?: boolean): string;
    /**
     *
     * @param volid
     */
    static VolidTrim(volid?: string): string;
    /**
     * Return postfix
     * @param basename
     * @returns eggName
     */
    static getPostfix(): string;
    /**
     * Calculate the space used on the disk
     * @return {void}
     */
    static getUsedSpace(): number;
    /**
     * Extimate the linuxfs dimension
     * probably is better to rename it as
     * getLiveSpaceRootNeed
     * @returns {number} Byte
     */
    static getLiveRootSpace(type?: string): number;
    /**
     * Return true if i686 architecture
     * @remarks to move in Utils
     * @returns {boolean} true se l'architettura è i686
     */
    static isi686(): boolean;
    /**
     * Controlla se è un pacchetto deb
     * /usr/lib/penguins-eggs/bin/node
     */
    static isPackage(): boolean;
    /**
     * Controlla se è un pacchetto sorgente
     */
    static isSources(): boolean;
    /**
     * Controlla se è un pacchetto npm
     */
    static isNpmPackage(): boolean;
    /**
     *
     */
    static rootPenguin(): string;
    /**
     * return the short name of the package: eggs
     * @returns eggs
     */
    static getFriendName(): string;
    /**
     * return the version of the package
     * @returns version example 8.0.0
     */
    static getPackageVersion(): string;
    /**
     * Get author name
     */
    static getAuthorName(): string;
    /**
     * Return the Debian version
     * @returns {number} Versione di Debian
     */
    static getDebianVersion(): number;
    /**
     * Return true if live system
     * @returns {boolean} isLive
     */
    static isLive(): boolean;
    /**
     * Ritorna vero se path è un mountpoint
     * @param path
     */
    static isMountpoint(path?: string): boolean;
    /**
     *
     * @param device
     * @returns
     */
    static isBlockDevice(device?: string): boolean;
    /**
     * return true if eggs run as root
     * @returns isRoot
     */
    static isRoot(command?: string): boolean;
    /**
     *
     * @param command
     */
    static useRoot(command?: string): void;
    /**
     * get the kernel version
     */
    static kernelVersion(): string;
    /**
     * return the name of network device
     */
    static iface(): Promise<string>;
    /**
     * address
     */
    static address(): string;
    /**
     * netmask
     */
    static netmask(): string;
    /**
     * cidr
     */
    static cidr(): string;
    static broadcast(): string;
    /**
     * dns
     */
    static getDns(): string[];
    /**
     * getDomain
     */
    static getDomain(): string;
    /**
     * @returns gateway
     */
    static gateway(): string;
    /**
     * write a file
     * @param file
     * @param text
     */
    static write(file: string, text: string): void;
    /**
     *
     * @param file
     * @param cmd
     */
    static writeX(file: string, cmd: string): void;
    /**
     *
     * @param file
     * @param cmd
     */
    static writeXs(file: string, cmds: string[]): void;
    /**
     *
     * @param msg
     */
    static customConfirm(msg?: string): Promise<boolean>;
    /**
     *
     * @param msg
     */
    static customConfirmCompanion(msg?: string): Promise<any>;
    /**
     *
     * @param msg
     */
    static customConfirmAbort(msg?: string): Promise<any>;
    /**
     *
     */
    static pressKeyToExit(warning?: string, procContinue?: boolean): Promise<void>;
    static debug(cmd?: string, procContinue?: boolean): Promise<void>;
    /**
     * titles
     * Penguin's are gettings alive!
     */
    static titles(command?: string): void;
    /**
     *
     * @returns flag
     */
    static flag(): string;
    /**
     *
     * @param verbose
     */
    static setEcho(verbose?: boolean): object;
    /**
     *
     * @param bytes
     * @param decimals
     * @returns
     */
    static formatBytes(bytes: number, decimals?: number): string;
    /**
     *
     * @returns wardrobe
     */
    static wardrobe(): Promise<string>;
    static getOsRelease(): IOsRelease;
    static sleep(ms?: number): Promise<void>;
    /**
     * chpasswdPath
     * @returns
     */
    static chpasswdPath(): string;
}
